<?php

namespace App\Modules\Group\Application\CopyProviders;

use App\Modules\Group\Domain\GroupRepositoryAlter;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

final class GroupProvidersCopier
{
    public function __construct(
        private GroupRepositoryAlter $repository,
        private QueryBus $bus
    ) {
    }

    public function __invoke(
        IdGroup $idGroup,
    ): CopyProvidersGroupResponse {
        return new CopyProvidersGroupResponse($this->repository->copyProviders($idGroup));
    }
}
