<?php

namespace App\Modules\FactUnit\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListFactUnit implements StorageCriteria
{

    public function __construct(private string $action) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactUnit::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`FactUnit_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`FactUnit_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`FactUnit_Status` = 0';
        } else {
            $where = '`ftd`.`FactUnit_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_fact_unit` `ftd`
            WHERE $where",
            [ ]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
