<?php

namespace App\Modules\FactTypeReceipt\Infraestructure;

use App\Modules\FactTypeReceipt\Domain\FactTypeReceipt;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptRepository;
use App\Modules\FactTypeReceipt\Domain\IdFactTypeReceipt;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlFactTypeReceiptRepository implements FactTypeReceiptRepository
{

    public function find(StorageCriteria $criteria): FactTypeReceipt
    {
        return FactTypeReceipt::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => FactTypeReceipt::fromDTO($btp), $criteria->run());
    }

    public function insert(FactTypeReceipt $value)
    {
        return Requester::requestInsert(
            'CALL sp_fact_type_receipt_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->name()->value(),
                $value->abrv()->value(),
                $value->status()->value()
            ]
        );
    }

    public function update(FactTypeReceipt $value)
    {
        return Requester::requestUpdate(
            'CALL sp_fact_type_receipt_update(?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->abrv()->value(),
                $value->status()->value(),
            ]
        );
    }
}
