<?php

namespace App\Modules\FactTypeReceipt\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class FactTypeReceipt extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactTypeReceipt::class, 'Id_FactTypeReceipt'),
            new AggregateAttribute('name', FactTypeReceiptName::class, 'FactTypeReceipt_Name'),
            new AggregateAttribute('abrv', FactTypeReceiptAbrv::class, 'FactTypeReceipt_Abrv'),
            new AggregateAttribute('status', FactTypeReceiptStatus::class, 'FactTypeReceipt_Status')
        ];
    }

    public function __construct(
        private IdFactTypeReceipt $id,
        private FactTypeReceiptName $name,
        private FactTypeReceiptAbrv $abrv,
        private FactTypeReceiptStatus $status,
    ) {
    }

    public function id(): IdFactTypeReceipt
    {
        return $this->id;
    }

    public function name(): FactTypeReceiptName
    {
        return $this->name;
    }

    public function abrv(): FactTypeReceiptAbrv
    {
        return $this->abrv;
    }

    public function status(): FactTypeReceiptStatus
    {
        return $this->status;
    }
}
