<?php

namespace App\Modules\FactTypeReceipt\Application\Index;

use App\Modules\FactTypeReceipt\Application\FactTypeReceiptResponse;
use App\Modules\FactTypeReceipt\Domain\IdFactTypeReceipt;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactTypeReceiptIndexerQueryHandler implements QueryHandler
{
    public function __construct(private FactTypeReceiptIndexer $inserter)
    {
    }

    public function __invoke(FactTypeReceiptIndexerQuery $query): FactTypeReceiptResponse
    {
        $model = $this->inserter->__invoke(new IdFactTypeReceipt($query->getId()));
        return new FactTypeReceiptResponse(
            $model->id()->value(),
            $model->name()->value(),
            $model->abrv()->value(),
            $model->status()->value(),
        );
    }
}
