<?php

namespace App\Modules\FactTypeOperation\Application\Update;

use App\Modules\FactTypeOperation\Domain\IdFactTypeOperation;
use App\Modules\FactTypeOperation\Domain\FactTypeOperation;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationAddress;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationContactName;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationContactPhone;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationEmail;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationGender;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationAbrv;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationName;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationNoDocument;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationPhone;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationPhoneCode;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationStatus;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

final class FactTypeOperationUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private FactTypeOperationUpdater $updater)
    {
    }

    public function __invoke(FactTypeOperationUpdaterQuery $query): FactTypeOperationUpdaterResponse
    {
        $model = new FactTypeOperation(
            new IdFactTypeOperation($query->getId()),
            new FactTypeOperationName($query->getName()),
            new FactTypeOperationAbrv($query->getAbrv()),
            new FactTypeOperationStatus($query->getStatus()),
        );
        return $this->updater->__invoke($model);
    }
}
