<?php

namespace App\Modules\FactTypeDocument\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexFactTypeDocument implements StorageCriteria
{

    public function __construct(
        private IdFactTypeDocument $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactTypeDocument::select('`ftd`');
        return DB::select(
            "SELECT $select
            FROM `t_fact_type_document` `ftd`
            WHERE `ftd`.`Id_FactTypeDocument` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new FactTypeDocumentNotFound();
        }
        return $data[0];
    }
}
