<?php

namespace App\Modules\FactReceiptDetail\Application\List;

use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceiptDetail\Application\FactReceiptDetailResponse;
use App\Modules\FactReceiptDetail\Application\FactReceiptDetailResponses;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetail;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactReceiptDetailListerQueryHandler implements QueryHandler
{
    public function __construct(private FactReceiptDetailLister $lister)
    {
    }

    public function __invoke(FactReceiptDetailListerQuery $query): FactReceiptDetailResponses
    {
        return new FactReceiptDetailResponses(...array_map(
            fn (FactReceiptDetail $index) => new FactReceiptDetailResponse(
                $index->id()->value(),
                $index->amount()->value(),
                $index->unitPrice()->value(),
                $index->discount()->value(),
                $index->total()->value(),
                $index->status()->value(),
                (object)[
                    'Id_FactProduct' => $index->idFactProduct()->id()->value(),
                    'FactProduct_Code' => $index->idFactProduct()->code()->value(),
                    'FactProduct_Name' => $index->idFactProduct()->name()->value(),
                    'FactProduct_IdProduct' => $index->idFactProduct()->idProduct()->value(),
                    'FactProduct_Status' => $index->idFactProduct()->status()->value(),
                ],
                $index->idFactTypeOperation()->value(),
                $index->idFactUnit()->value(),
                $index->idFactReceipt()->value(),
            ),
            $this->lister->__invoke(new IdFactReceipt($query->getIdFactReceipt()), $query->getAction())
        ));
    }
}
