<?php

namespace App\Modules\FactReceipt\Infraestructure;

use App\Modules\FactReceipt\Domain\FactReceipt;
use App\Modules\FactReceipt\Domain\FactReceiptRepository;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceipt\Domain\InsertFactReceipt;
use App\Modules\FactReceipt\Domain\UpdateFactReceipt;
use App\Modules\FactReceipt\Domain\UpdateStatusFactReceipt;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlFactReceiptRepository implements FactReceiptRepository
{

    public function find(StorageCriteria $criteria): FactReceipt
    {
        return FactReceipt::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn ($btp) => FactReceipt::fromDTO($btp), $criteria->run());
    }

    public function createWithCashMovement(InsertFactReceipt $model)
    {
        return Requester::requestInsert(
            'CALL sp_fact_receipt_insert_with_cash_movement(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $model->date()->value(),
                $model->dateUpdate()->value(),
                $model->dateEmission()->value(),
                $model->noDocument()->value(),
                $model->businessName()->value(),
                $model->email()->value(),
                $model->address()->value(),
                $model->licensePlate()->value(),
                $model->currency()->value(),
                $model->responseMessage()->value(),
                $model->status()->value(),
                $model->idFactTypeReceipt()->value(),
                $model->idFactTypeDocument()->value(),
                $model->idFactPaymentMethod()->value(),
                $model->idFactCurrency()->value(),
                $model->idCashMovement()->value(),
            ]
        );
    }

    public function create(FactReceipt $value)
    {
        return Requester::requestInsert(
            'CALL sp_fact_receipt_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->date()->value(),
                $value->dateUpdate()->value(),
                $value->dateEmission()->value(),
                $value->noDocument()->value(),
                $value->businessName()->value(),
                $value->email()->value(),
                $value->address()->value(),
                $value->licensePlate()->value(),
                $value->currency()->value(),
                $value->responseMessage()->value(),
                $value->status()->value(),
                $value->idFactTypeReceipt()->value(),
                $value->idFactTypeDocument()->value(),
                $value->idFactPaymentMethod()->value(),
                $value->idFactCurrency()->value(),
            ]
        );
    }

    public function update(UpdateFactReceipt $value)
    {
        return Requester::requestUpdate(
            'CALL sp_fact_receipt_update(?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->dateEmission()->value(),
                $value->noDocument()->value(),
                $value->businessName()->value(),
                $value->email()->value(),
                $value->address()->value(),
                $value->licensePlate()->value(),
                $value->currency()->value(),
                $value->idFactTypeReceipt()->value(),
                $value->idFactTypeDocument()->value(),
                $value->idFactPaymentMethod()->value(),
                $value->idFactCurrency()->value(),
            ]
        );
    }

    public function delete(IdFactReceipt $id)
    {
        return Requester::requestUpdate(
            'CALL sp_fact_receipt_delete(?,@sts,@cod,@msg)',
            [
                $id()->value(),
            ]
        );
    }

    public function updateStatus(UpdateStatusFactReceipt $model)
    {
        return Requester::requestUpdate(
            'CALL sp_fact_receipt_update_status(?,?,?,@sts,@cod,@msg)',
            [
                $model->id()->value(),
                $model->responseMessage()->value(),
                $model->status()->value()
            ]
        );
    }
}
