<?php

namespace App\Modules\FactReceipt\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;

interface FactReceiptRepository
{
    public function find(StorageCriteria $action): FactReceipt;
    public function search(StorageCriteria $action): array;
    public function create(FactReceipt $model);
    public function createWithCashMovement(InsertFactReceipt $model);
    public function update(UpdateFactReceipt $model);
    public function delete(IdFactReceipt $id);
    public function updateStatus(UpdateStatusFactReceipt $model);
}
