<?php

namespace App\Modules\FactReceipt\Application\Create;

use App\Modules\FactCurrency\Domain\IdFactCurrency;
use App\Modules\FactPaymentMethod\Domain\IdFactPaymentMethod;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceipt\Domain\FactReceipt;
use App\Modules\FactReceipt\Domain\FactReceiptAddress;
use App\Modules\FactReceipt\Domain\FactReceiptBusinessName;
use App\Modules\FactReceipt\Domain\FactReceiptCurrency;
use App\Modules\FactReceipt\Domain\FactReceiptDate;
use App\Modules\FactReceipt\Domain\FactReceiptDateEmission;
use App\Modules\FactReceipt\Domain\FactReceiptDateUpdate;
use App\Modules\FactReceipt\Domain\FactReceiptEmail;
use App\Modules\FactReceipt\Domain\FactReceiptLicensePlate;
use App\Modules\FactReceipt\Domain\FactReceiptNoDocument;
use App\Modules\FactReceipt\Domain\FactReceiptResponseMessage;
use App\Modules\FactReceipt\Domain\FactReceiptStatus;
use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;
use App\Modules\FactTypeReceipt\Domain\IdFactTypeReceipt;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateFactReceiptQueryHandler implements QueryHandler
{
    public function __construct(private FactReceiptCreator $creator)
    {
    }

    public function __invoke(CreateFactReceiptQuery $query): CreateFactReceiptResponse
    {
        $model = new FactReceipt(
            new IdFactReceipt(0),
            new FactReceiptDate($query->date()),
            new FactReceiptDateUpdate($query->dateUpdate()),
            new FactReceiptDateEmission($query->dateEmission()),
            new FactReceiptNoDocument($query->noDocument()),
            new FactReceiptBusinessName($query->businessName()),
            new FactReceiptEmail($query->email()),
            new FactReceiptAddress($query->address()),
            new FactReceiptLicensePlate($query->licensePlate()),
            new FactReceiptCurrency($query->currency()),
            new FactReceiptResponseMessage($query->responseMessage()),
            new FactReceiptStatus($query->status()),
            new IdFactTypeReceipt($query->idFactTypeReceipt()),
            new IdFactTypeDocument($query->idFactTypeDocument()),
            new IdFactPaymentMethod($query->idFactPaymentMethod()),
            new IdFactCurrency($query->idFactCurrency()),
        );
        return new CreateFactReceiptResponse($this->creator->__invoke($model));
    }
}
