<?php

namespace App\Modules\FactProduct\Infraestructure;

use App\Modules\FactProduct\Domain\FactProduct;
use App\Modules\FactProduct\Domain\FactProductRepository;
use App\Modules\FactProduct\Domain\IdFactProduct;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlFactProductRepository implements FactProductRepository
{

    public function find(StorageCriteria $criteria): FactProduct
    {
        return FactProduct::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => FactProduct::fromDTO($btp), $criteria->run());
    }

    public function insert(FactProduct $value)
    {
        return Requester::requestInsert(
            'CALL sp_fact_product_insert(?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->code()->value(),
                $value->name()->value(),
                $value->idProduct()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function update(FactProduct $value)
    {
        return Requester::requestUpdate(
            'CALL sp_fact_product_update(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->code()->value(),
                $value->name()->value(),
                $value->idProduct()->value(),
                $value->status()->value(),
            ]
        );
    }
}
