<?php

namespace App\Modules\FactProduct\Application\Update;

use App\Modules\FactProduct\Domain\IdFactProduct;
use App\Modules\FactProduct\Domain\FactProduct;
use App\Modules\FactProduct\Domain\FactProductAbrv;
use App\Modules\FactProduct\Domain\FactProductCode;
use App\Modules\FactProduct\Domain\FactProductIdProduct;
use App\Modules\FactProduct\Domain\FactProductName;
use App\Modules\FactProduct\Domain\FactProductStatus;
use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactProductUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private FactProductUpdater $updater)
    {
    }

    public function __invoke(FactProductUpdaterQuery $query): FactProductUpdaterResponse
    {
        $model = new FactProduct(
            new IdFactProduct($query->getId()),
            new FactProductCode($query->getCode()),
            new FactProductName($query->getName()),
            new FactProductIdProduct($query->getIdProduct()),
            new FactProductStatus($query->getStatus()),
        );
        return $this->updater->__invoke($model);
    }
}
