<?php

namespace App\Modules\FactProduct\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class FactProductUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private string $code,
        private string $name,
        private string $idProduct,
        private int $status,
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }
    public function getName(): string
    {
        return $this->name;
    }
    public function getCode(): string
    {
        return $this->code;
    }
    public function getIdProduct(): string
    {
        return $this->idProduct;
    }
    public function getStatus(): int
    {
        return $this->status;
    }
}
