<?php

namespace App\Modules\FactCurrency\Infrastructure;

use App\Modules\FactCurrency\Domain\FactCurrency;
use App\Modules\FactCurrency\Domain\FactCurrencyRepository;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;

class MysqlFactCurrencyRepository implements FactCurrencyRepository
{

    public function find(StorageCriteria $criteria): FactCurrency | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return FactCurrency::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn ($btp) => FactCurrency::fromDTO($btp), $criteria->run());
    }

    public function insert(FactCurrency $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(FactCurrency $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
