<?php

namespace App\Modules\FactCurrency\Application\Index;

use App\Modules\FactCurrency\Application\FactCurrencyResponse;
use App\Modules\FactCurrency\Domain\IdFactCurrency;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexFactCurrencyQueryHandler implements QueryHandler
{
    public function __construct(private FactCurrencyIndexer $inserter)
    {
    }

    public function __invoke(IndexFactCurrencyQuery $query): FactCurrencyResponse
    {
        $model = $this->inserter->__invoke(new IdFactCurrency($query->getId()));
        return new FactCurrencyResponse(
            $model->id()->value(),
            $model->name()->value(),
            $model->abrv()->value(),
            $model->status()->value(),
        );
    }
}
