<?php

namespace App\Modules\FactCurrency\Application\Delete;

use App\Modules\FactCurrency\Domain\IdFactCurrency;
use App\Modules\FactCurrency\Application\Index\FactCurrencyIndexer;
use App\Modules\FactCurrency\Application\Update\FactCurrencyUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteFactCurrencyQueryHandler implements QueryHandler
{
    public function __construct(
        private FactCurrencyUpdater $update,
        private FactCurrencyIndexer $indexer
    ) {
    }

    public function __invoke(DeleteFactCurrencyQuery $query): DeleteFactCurrencyResponse
    {
        $index = $this->indexer->__invoke(new IdFactCurrency($query->idFactCurrency()), true);
        $index->delete();
        $this->update->__invoke($index);
        return new DeleteFactCurrencyResponse();
    }
}
