<?php

namespace App\Modules\FactCurrency\Application\Create;

use App\Modules\FactCurrency\Domain\IdFactCurrency;
use App\Modules\FactCurrency\Domain\FactCurrency;
use App\Modules\FactCurrency\Domain\FactCurrencyAbrv;
use App\Modules\FactCurrency\Domain\FactCurrencyName;
use App\Modules\FactCurrency\Domain\FactCurrencyStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateFactCurrencyQueryHandler implements QueryHandler
{
    public function __construct(private FactCurrencyCreator $creator)
    {
    }

    public function __invoke(CreateFactCurrencyQuery $query): CreateFactCurrencyResponse
    {
        $model = new FactCurrency(
            new IdFactCurrency(0),
            new FactCurrencyName($query->name()),
            new FactCurrencyAbrv($query->abrv()),
            new FactCurrencyStatus($query->status()),
        );
        return new CreateFactCurrencyResponse($this->creator->__invoke($model));
    }
}
