<?php

namespace App\Modules\ExternalReviewProvider\Domain;

use App\Modules\ExternalReview\Domain\IdExternalReview;
use App\Modules\GroupProvider\Domain\IdGroupProvider;

class ExternalReviewProvider
{

    /** constructor */
    public function __construct(
        private ExternalReviewProviderType $type,
        private ExternalReviewProviderStatus $status,
        private IdExternalReview $idExternalReview,
        private IdGroupProvider $idGroupProvider,
        private ?IdExternalReviewProvider $id = null
    ) {
    }
    public function getType(): ExternalReviewProviderType
    {
        return $this->type;
    }
    public function getStatus(): ExternalReviewProviderStatus
    {
        return $this->status;
    }
    public function getIdExternalReview(): IdExternalReview
    {
        return $this->idExternalReview;
    }
    public function getIdGroupProvider(): IdGroupProvider
    {
        return $this->idGroupProvider;
    }
    public function getId(): IdExternalReviewProvider
    {
        return $this->id;
    }
}
