<?php

namespace App\Modules\ExternalApiRequest\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class ExternalApiRequest extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdExternalApiRequest::class, 'Id_ExternalApiRequest', 'primary'),
            new AggregateAttribute('date', ExternalApiRequestDate::class, 'ExternalApiRequest_Date'),
            new AggregateAttribute('apiUrl', ExternalApiRequestApiUrl::class, 'ExternalApiRequest_ApiUrl'),
            new AggregateAttribute('method', ExternalApiRequestMethod::class, 'ExternalApiRequest_Method'),
            new AggregateAttribute('body', ExternalApiRequestBody::class, 'ExternalApiRequest_Body'),
            new AggregateAttribute('response', ExternalApiRequestResponse::class, 'ExternalApiRequest_Response'),
            new AggregateAttribute('status', ExternalApiRequestStatus::class, 'ExternalApiRequest_Status')
        ];
    }

    protected static function table(): string
    {
        return 't_external_api_request';
    }

    public function __construct(
        protected IdExternalApiRequest $id,
        protected ExternalApiRequestDate $date,
        protected ExternalApiRequestApiUrl $apiUrl,
        protected ExternalApiRequestMethod $method,
        protected ExternalApiRequestBody $body,
        protected ExternalApiRequestResponse $response,
        protected ExternalApiRequestStatus $status,
    ) {
    }

    public function id(): IdExternalApiRequest
    {
        return $this->id;
    }

    public function date(): ExternalApiRequestDate
    {
        return $this->date;
    }

    public function apiUrl(): ExternalApiRequestApiUrl
    {
        return $this->apiUrl;
    }
    public function method(): ExternalApiRequestMethod
    {
        return $this->method;
    }
    public function body(): ExternalApiRequestBody
    {
        return $this->body;
    }
    public function response(): ExternalApiRequestResponse
    {
        return $this->response;
    }

    public function status(): ExternalApiRequestStatus
    {
        return $this->status;
    }

    public function setResponse(ExternalApiRequestResponse $response): void
    {
        $this->response = $response;
    }

    public function setStatus(ExternalApiRequestStatus $status): void
    {
        $this->status = $status;
    }
}
