<?php

namespace App\Modules\ExternalApiRequest\Application\Create;

use App\Modules\ExternalApiRequest\Domain\IdExternalApiRequest;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequest;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestApiUrl;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestBody;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestDate;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestMethod;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestResponse;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateExternalApiRequestQueryHandler implements QueryHandler
{
    public function __construct(private ExternalApiRequestCreator $updater)
    {
    }

    public function __invoke(CreateExternalApiRequestQuery $query): CreateExternalApiRequestResponse
    {
        $model = new ExternalApiRequest(
            new IdExternalApiRequest(0),
            new ExternalApiRequestDate($query->date()),
            new ExternalApiRequestApiUrl($query->apiUrl()),
            new ExternalApiRequestMethod($query->method()),
            new ExternalApiRequestBody($query->body()),
            new ExternalApiRequestResponse($query->response()),
            new ExternalApiRequestStatus($query->status()),
        );
        return new CreateExternalApiRequestResponse($this->updater->__invoke($model));
    }
}
