<?php

namespace App\Modules\CashMovementFactReceipt\Domain;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListCashMovementFactReceipt implements StorageCriteria
{

    public function __construct(
        private IdCashMovement $idcashMovement,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = CashMovementFactReceipt::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`CashMovementFactReceipt_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`CashMovementFactReceipt_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`CashMovementFactReceipt_Status` = 0';
        } else {
            $where = '`ftd`.`CashMovementFactReceipt_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_cash_movement_fact_receipt` `ftd`
            WHERE $where
            AND `ftd`.`Id_CashMovement` = ?",
            [$this->idcashMovement->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
