<?php

namespace App\Modules\CashMovementFactReceipt\Application\Update;

use App\Modules\CashMovementFactReceipt\Application\Update\CashMovementFactReceiptUpdaterResponse;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceiptRepository;

final class CashMovementFactReceiptUpdater
{
    public function __construct(private CashMovementFactReceiptRepository $repository)
    {
    }

    public function __invoke(CashMovementFactReceipt $lead): CashMovementFactReceiptUpdaterResponse
    {
        return new CashMovementFactReceiptUpdaterResponse($this->repository->update($lead));
    }
}
