<?php

namespace App\Modules\CashMovementFactReceipt\Application\List;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovementFactReceipt\Application\CashMovementFactReceiptResponse;
use App\Modules\CashMovementFactReceipt\Application\CashMovementFactReceiptResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListCashMovementFactReceiptQueryHandler implements QueryHandler
{
    public function __construct(private CashMovementFactReceiptLister $lister)
    {
    }

    public function __invoke(ListCashMovementFactReceiptQuery $query): CashMovementFactReceiptResponses
    {
        return new CashMovementFactReceiptResponses(...array_map(
            fn ($index) => new CashMovementFactReceiptResponse(
                $index->id()->value(),
                $index->status()->value(),
                $index->idCashMovement()->value(),
                $index->idFactReceipt()->value(),
            ),
            $this->lister->__invoke(new IdCashMovement($query->getIdCashMovement()), $query->getAction())
        ));
    }
}
