<?php

namespace App\Modules\CashMovementFactReceipt\Application\Create;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\IdCashMovementFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceiptStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateCashMovementFactReceiptQueryHandler implements QueryHandler
{
    public function __construct(private CashMovementFactReceiptCreator $creator)
    {
    }

    public function __invoke(CreateCashMovementFactReceiptQuery $query): CreateCashMovementFactReceiptResponse
    {
        $model = new CashMovementFactReceipt(
            new IdCashMovementFactReceipt(0),
            new CashMovementFactReceiptStatus($query->status()),
            new IdCashMovement($query->idCashMovement()),
            new IdFactReceipt($query->idFactReceipt()),
        );
        return $this->creator->__invoke($model);
    }
}
