<?php

namespace App\Modules\CashMovement\Infraestructure;

use App\Modules\CashMovement\Domain\CashMovementUpdateRepository;
use App\Modules\CashMovement\Domain\UpdateCashMovement;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlCashMovementUpdateRepository implements CashMovementUpdateRepository
{
    public function update(UpdateCashMovement $model)
    {
        return Requester::requestUpdate(
            'CALL sp_cash_movement_update(?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $model->getIdCashMovement()->value(),
                $model->getCashMovementName()->value(),
                $model->getCashMovementLastName()->value(),
                $model->getCashMovementEmail()->value(),
                $model->getCashMovementCountry()->value(),
                $model->getCashMovementCity()->value(),
                $model->getCashMovementAddress()->value(),
                $model->getCashMovementReceiptNumber()->value(),
                $model->getCashMovementCardNumber()->value(),
                $model->getCashMovementCardIssuer()->value(),
                $model->getCashMovementRemark()->value(),
                $model->getIdTypePayment()->value()
            ]
        );
    }
}
