<?php

namespace App\Modules\CashMovement\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\TypePayment\Domain\IdTypePayment;

class RedistributeCashMovement {

    private CashMovementDatePayment $datePayment;
    private CashMovementAmount $amount;
    private CashMovementCurrency $currency;
    private CashMovementName $name;
    private CashMovementLastName $lastName;
    private CashMovementEmail $email;
    private CashMovementCountry $country;
    private CashMovementCity $city;
    private CashMovementAddress $address;
    private CashMovementPhone $phone;
    private CashMovementReceiptNumber $receiptNumber;
    private CashMovementCardLast $cardLast;
    private CashMovementCardNumber $cardNumber;
    private CashMovementCardBrand $cardBrand;
    private CashMovementCardType $cardType;
    private CashMovementCardIssuer $cardIssuer;
    private CashMovementRemark $remark;
    private IdTypePayment $idTypePayment;
    private IdAdmin $idAdmin;
    private InvoiceDataCollection $invoiceIn;
    private InvoiceDataCollection $invoiceOut;

    public function __construct(
        CashMovementDatePayment $datePayment,
        CashMovementAmount $amount,
        CashMovementCurrency $currency,
        CashMovementName $name,
        CashMovementLastName $lastName,
        CashMovementEmail $email,
        CashMovementCountry $country,
        CashMovementCity $city,
        CashMovementAddress $address,
        CashMovementPhone $phone,
        CashMovementReceiptNumber $receiptNumber,
        CashMovementCardLast $cardLast,
        CashMovementCardNumber $cardNumber,
        CashMovementCardBrand $cardBrand,
        CashMovementCardType $cardType,
        CashMovementCardIssuer $cardIssuer,
        CashMovementRemark $remark,
        IdTypePayment $idTypePayment,
        IdAdmin $idAdmin,
        InvoiceDataCollection $invoicesIn,
        InvoiceDataCollection $invoicesOut
    ) {
        $this->datePayment = $datePayment;
        $this->amount = $amount;
        $this->currency = $currency;
        $this->name = $name;
        $this->lastName = $lastName;
        $this->email = $email;
        $this->country = $country;
        $this->city = $city;
        $this->address = $address;
        $this->phone = $phone;
        $this->receiptNumber = $receiptNumber;
        $this->cardLast = $cardLast;
        $this->cardNumber = $cardNumber;
        $this->cardBrand = $cardBrand;
        $this->cardType = $cardType;
        $this->cardIssuer = $cardIssuer;
        $this->remark = $remark;
        $this->idTypePayment = $idTypePayment;
        $this->idAdmin = $idAdmin;
        $this->invoicesIn = $invoicesIn;
        $this->invoicesOut = $invoicesOut;
    }

    public function datePayment():CashMovementDatePayment { return $this->datePayment; }
    public function amount():CashMovementAmount { return $this->amount; }
    public function currency():CashMovementCurrency { return $this->currency; }
    public function name():CashMovementName { return $this->name; }
    public function lastName():CashMovementLastName { return $this->lastName; }
    public function email():CashMovementEmail { return $this->email; }
    public function country():CashMovementCountry { return $this->country; }
    public function city():CashMovementCity { return $this->city; }
    public function address():CashMovementAddress { return $this->address; }
    public function phone():CashMovementPhone { return $this->phone; }
    public function receiptNumber():CashMovementReceiptNumber { return $this->receiptNumber; }
    public function cardLast():CashMovementCardLast { return $this->cardLast; }
    public function cardNumber():CashMovementCardNumber { return $this->cardNumber; }
    public function cardBrand():CashMovementCardBrand { return $this->cardBrand; }
    public function cardType():CashMovementCardType { return $this->cardType; }
    public function cardIssuer():CashMovementCardIssuer { return $this->cardIssuer; }
    public function remark():CashMovementRemark { return $this->remark; }
    public function idTypePayment():IdTypePayment { return $this->idTypePayment; }
    public function idAdmin():IdAdmin { return $this->idAdmin; }
    public function invoicesIn():InvoiceDataCollection { return $this->invoicesIn; }
    public function invoicesOut():InvoiceDataCollection { return $this->invoicesOut; }

}