<?php

namespace App\Modules\CashMovement\Application\UpdateCycleType;

use App\Modules\CashMovement\Domain\CashMovementCycleType;
use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateCycleTypeCashMovementQueryHandler implements QueryHandler
{
    public function __construct(private CashMovementCycleTypeUpdater $cycleTypeUpdater)
    {
    }

    public function __invoke(UpdateCycleTypeCashMovementQuery $query): UpdateCycleTypeCashMovementResponse
    {
        return $this->cycleTypeUpdater->__invoke(new IdCashMovement($query->id()), new CashMovementCycleType($query->cycleType()));
    }
}
