<?php

namespace App\Modules\CalendarTour\Infrastructure;

use App\Modules\CalendarTour\Domain\CalendarTourAlterRepository;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Infraestructure\Requester;
use App\Modules\Tour\Domain\IdTour;

class MysqlCalendarTourAlterRepository implements CalendarTourAlterRepository
{
    public function tourPassengerList(
        IdTour $idTour,
        DateStart $dateStart
    ) {
        return Requester::requestSelect(
            'CALL sp_calendar_tour_passenger_list(?,?,?,@sts,@cod,@msg)',
            [
                $idTour->value(),
                $dateStart->value(),
                config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB')
            ]
        );
    }
}
