<?php

namespace App\Modules\Briefing\Application\List;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ListBriefingQuery implements Query
{
    public function __construct(
        private string $dateTimeStart,
        private string $dateTimeEnd,
        private string $type,
        private string $orderBy,
    ) {
    }

    public function dateTimeStart()
    {
        return $this->dateTimeStart;
    }

    public function dateTimeEnd()
    {
        return $this->dateTimeEnd;
    }

    public function type()
    {
        return $this->type;
    }

    public function orderBy()
    {
        return $this->orderBy;
    }
}
