<?php

namespace App\Modules\BookingUpgradePassenger\Infrastructure;

class BookingUpgradePassengerValidators
{
    public const UPDATE = [
        'BookingUpgradePassenger_OnlyReturn'    => 'required|int',
        'BookingUpgradePassenger_DateEntry'     => 'required|string',
        'BookingUpgradePassenger_Datereturn'    => 'required|string',
        'BookingUpgradePassenger_DatePurchase'  => 'required|string',
        'BookingUpgradePassenger_Carrier'       => 'required|string',
        'BookingUpgradePassenger_Code'          => 'required|string',
        'BookingUpgradePassenger_Amount'        => 'required|numeric',
        'BookingUpgradePassenger_RoundCarrier'  => 'string',
        'BookingUpgradePassenger_RoundCode'     => 'string',
        'BookingUpgradePassenger_RoundAmount'   => 'required|numeric',
        'BookingUpgradePassenger_Remark'        => 'string',
        'Id_BookingUpgradePassenger'            => 'required|int',
        'Id_Provider'                           => 'int',
        'Id_Provider_Return'                    => 'int'
    ];

    public const SIMPLE_UPDATE = [
        'Id_BookingUpgradePassenger'            => 'required|int',
        'BookingUpgradePassenger_DateEntry'     => 'required|string',
        'BookingUpgradePassenger_Datereturn'    => 'required|string',
    ];

    public const MASK = [
        'Id_BookingUpgradePassenger'          => 'required|int',
        'BookingUpgradePassenger_Mask'        => 'required|int',
    ];

    public const DELETE = [
        'Keep_InvoiceDetail' => 'required|int',
        'Generate_More' => 'required|int',
        'InvoiceDetail_Price' => 'required|numeric',
        'InvoiceDetail_Description' => 'required|string|max:250'
    ];

    public const LIST_BY_IDS = [
        'Ids'                               => 'required|array',
        'Ids.*'                             => 'required|int',
    ];

    public const MASSIVE_UPDATE = [
        'BookingUpgradePassenger'               =>  'required|array',
        'BookingUpgradePassenger.*'             =>  'required|int',
        'BookingUpgradePassenger_DateEntry'     => 'required|string',
        'BookingUpgradePassenger_Datereturn'    => 'required|string',
        'BookingUpgradePassenger_DatePurchase'  => 'required|string',
        'BookingUpgradePassenger_Carrier'       => 'required|string',
        'BookingUpgradePassenger_Code'          => 'required|string',
        'BookingUpgradePassenger_Amount'        => 'required|numeric',
        'BookingUpgradePassenger_RoundCarrier'  => 'string',
        'BookingUpgradePassenger_RoundCode'     => 'string',
        'BookingUpgradePassenger_RoundAmount'   => 'required|numeric',
        'BookingUpgradePassenger_Remark'        => 'string',
        'Id_Provider'                           => 'int',
        'Id_Provider_Return'                    => 'int'
    ];
}
