<?php

namespace App\Modules\BookingUpgradePassenger\Application\Remove;

use App\Modules\BookingAdditional\Application\Delete\DeleteBookingAdditionalQuery;
use App\Modules\BookingAdditional\Domain\BookingAdditionalType;
use App\Modules\BookingUpgradePassenger\Domain\IdBookingUpgradePassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class RemoveBookingUpgradePassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private BookingUpgradePassengerRemover $remover,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(RemoveBookingUpgradePassengerQuery $query): RemoveBookingUpgradePassengerResponse
    {
        $this->queryBus->ask(new DeleteBookingAdditionalQuery(BookingAdditionalType::BOOKING_UPGRADE_PASSENGER, $query->id()));
        return new RemoveBookingUpgradePassengerResponse(
            $this->remover->__invoke(
                new IdBookingUpgradePassenger($query->id()),
                $query->keepInvoice()
            )
        );
    }
}
