<?php

namespace App\Modules\BookingUpgradePassenger\Application\Remove;

use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerRepository;
use App\Modules\BookingUpgradePassenger\Domain\IdBookingUpgradePassenger;

class BookingUpgradePassengerRemover
{

    private BookingUpgradePassengerRepository $repository;

    public function __construct(
        BookingUpgradePassengerRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(IdBookingUpgradePassenger $id, int $keepInvoice)
    {
        return $this->repository->remove($id, $keepInvoice);
    }
}
