<?php

namespace App\Modules\BookingTourPassenger\Domain;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\BookingTour\Domain\BookingTourGroup;
use App\Modules\Passenger\Domain\IdPassenger;
use Illuminate\Support\Facades\DB;

class FromGroupBookingTourPassenger
{

    public function __construct(
        private BookingTourGroup $group,
        private IdPassenger $idPassenger
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        return DB::select(
            'SELECT `btp`.`Id_BookingTourPassenger`,
                    `btp`.`BookingTourPassenger_Lock`,
                    `btp`.`BookingTourPassenger_Reportable`,
                    `btp`.`BookingTourPassenger_Hotel`,
                    `btp`.`BookingTourPassenger_Remark`,
                    `btp`.`BookingTourPassenger_Price`,
                    `btp`.`BookingTourPassenger_Full`,
                    `btp`.`BookingTourPassenger_ValidGroups`,
                    `btp`.`BookingTourPassenger_NoValidGroups`,
                    `btp`.`BookingTourPassenger_Status`,
                    `btp`.`BookingTourPassenger_PaymentStatus`,
                    `btp`.`Id_BookingTour`,
                    `btp`.`Id_Passenger`
            FROM `t_booking_tour_passenger` `btp`
            INNER JOIN `t_booking_tour` `bt` ON `bt`.`Id_BookingTour` = `btp`.`Id_BookingTour`
            WHERE   `bt`.`BookingTour_Group` = ?
            AND     `bt`.`Id_Passenger` = ?',
            [
                $this->group->value(),
                $this->idPassenger->value()
            ]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
