<?php

namespace App\Modules\BookingTourPassenger\Application\ValidateGroups;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Command\CommandHandler;

final class BookingTourPassengerGroupsValidationHandler implements CommandHandler
{
    public function __construct(private BookingTourPassengerGroupsValidator $validator)
    {
    }

    public function __invoke(BookingTourPassengerGroupsValidationCommand $command)
    {
        return $this->validator->__invoke(new IdBookingTourPassenger($command->idBookingTourPassenger()));
    }
}
