<?php

namespace App\Modules\BookingTourPassenger\Application\Activate;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ActivateBookingTourPassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingTourPassengerActivator $changer)
    {
    }

    public function __invoke(ActivateBookingTourPassengerQuery $query): ActivateBookingTourPassengerResponse
    {
        return $this->changer->__invoke(
            new IdBookingTourPassenger($query->id())
        );
    }
}
