<?php

namespace App\Modules\BookingTour\Infraestructure;

use App\Modules\BookingTour\Domain\BookingTourPassengerListRepository;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Infraestructure\Format1Requester;
use Illuminate\Support\Facades\DB;

class MysqlBookingTourPassengerListRepository implements BookingTourPassengerListRepository
{
    public function list(string $action, IdBookingTour $idBookingTour, $id, $pathThumb)
    {
        return DB::select(
            'call sp_booking_tour_passenger_list(?,?,?,?)',
            [
                $action,
                $idBookingTour->getValue(),
                $id,
                $pathThumb
            ]
        );
    }

    public function price(IdBookingTour $idBookingTour, IdPassenger $idPassenger, int $total)
    {
        $response = Format1Requester::request(
            'CALL sp_booking_tour_passenger_price(?,?,?,?)',
            [
                $idBookingTour->getValue(),
                $idPassenger->value(),
                $total,
                1
            ]
        );

        Format1Requester::request(
            'call sp_invoice_reload(?,?)',
            [$idPassenger->value(), 1]
        );

        Format1Requester::request(
            'call sp_passenger_check_info_pay(?)',
            [$idPassenger->value()]
        );
        return $response;
    }
}
