<?php

namespace App\Modules\BookingTour\Domain;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Tour\Domain\IdTour;

class BookingTour
{
    public function __construct(
        private IdBookingTour $id,
        private BookingTourDateStart $dateStart,
        private BookingTourPickUp $pickUp,
        private BookingTourType $type,
        private BookingTourNoPax $noPax,
        private BookingTourName $name,
        private BookingTourTourName $tourName,
        private BookingTourFeeType $feeType,
        private BookingTourFull $full,
        private BookingTourMinimumFull $minimumFull,
        private BookingTourGroup $group,
        private BookingTourTourDuration $tourDuration,
        private BookingTourStatus $status,
        private IdBooking $idBooking,
        private IdPackage $idPackage,
        private IdTour $idTour,
    ) {
    }

    public static function fromDTO($dto)
    {
        return new BookingTour(
            new IdBookingTour($dto->Id_BookingTour),
            new BookingTourDateStart($dto->BookingTour_DateStart),
            new BookingTourPickUp($dto->BookingTour_PickUp),
            new BookingTourType($dto->BookingTour_Type),
            new BookingTourNoPax($dto->BookingTour_NoPax),
            new BookingTourName($dto->BookingTour_Name),
            new BookingTourTourName($dto->BookingTour_TourName),
            new BookingTourFeeType($dto->BookingTour_FeeType),
            new BookingTourFull($dto->BookingTour_Full),
            new BookingTourMinimumFull($dto->BookingTour_MinimumFull),
            new BookingTourGroup($dto->BookingTour_Group),
            new BookingTourTourDuration($dto->BookingTour_TourDuration),
            new BookingTourStatus($dto->BookingTour_Status),
            new IdBooking($dto->Id_Booking),
            new IdPackage($dto->Id_Package),
            new IdTour($dto->Id_Tour),
        );
    }

    public function id(): IdBookingTour
    {
        return $this->id;
    }

    public function dateStart(): BookingTourDateStart
    {
        return $this->dateStart;
    }

    public function pickUp(): BookingTourPickUp
    {
        return $this->pickUp;
    }

    public function type(): BookingTourType
    {
        return $this->type;
    }

    public function noPax(): BookingTourNoPax
    {
        return $this->noPax;
    }

    public function name(): BookingTourName
    {
        return $this->name;
    }

    public function tourName(): BookingTourTourName
    {
        return $this->tourName;
    }

    public function feeType(): BookingTourFeeType
    {
        return $this->feeType;
    }

    public function full(): BookingTourFull
    {
        return $this->full;
    }

    public function minimumFull(): BookingTourMinimumFull
    {
        return $this->minimumFull;
    }

    public function group(): BookingTourGroup
    {
        return $this->group;
    }

    public function tourDuration(): BookingTourTourDuration
    {
        return $this->tourDuration;
    }

    public function status(): BookingTourStatus
    {
        return $this->status;
    }

    public function idBooking(): IdBooking
    {
        return $this->idBooking;
    }

    public function idPackage(): IdPackage
    {
        return $this->idPackage;
    }

    public function idTour(): IdTour
    {
        return $this->idTour;
    }
}
