<?php

namespace App\Modules\BookingExtraPassenger\Application\Mask;

use App\Modules\BookingExtraPassenger\Domain\BookingExtraPassengerMask;
use App\Modules\BookingExtraPassenger\Domain\BookingExtraPassengerRepository;
use App\Modules\BookingExtraPassenger\Domain\IdBookingExtraPassenger;

class BookingExtraPassengerMasker
{

    private BookingExtraPassengerRepository $repository;

    public function __construct(BookingExtraPassengerRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdBookingExtraPassenger $id, BookingExtraPassengerMask $mask)
    {
        return new MaskBookingExtraPassengerResponse($this->repository->mask($id, $mask));
    }
}
