<?php

namespace App\Modules\BookingExtraPassenger\Application\ListById;

use App\Modules\BookingExtraPassenger\Domain\BookingExtraPassengerRepository;
use App\Modules\BookingExtraPassenger\Domain\ListByIdBookingExtraPassenger;

final class BookingExtraPassengerByIdLister
{
    public function __construct(private BookingExtraPassengerRepository $repository)
    {
    }

    public function __invoke(array $ids)
    {
        return $this->repository->search(new ListByIdBookingExtraPassenger($ids));
    }
}
