<?php

namespace App\Modules\BookingCalendar\Application\List;

use App\Modules\BookingCalendar\Domain\BookingCalendarRepository;
use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\TypeTour\Domain\IdTypeTour;

final class BookingCalendarLister
{
    public function __construct(private BookingCalendarRepository $repository)
    {
    }

    public function __invoke(
        IdCategoryTour $idCategoryTour,
        IdTypeTour $idTypeTour,
        IdTour $idTour,
        IdPackage $idPackage,
        DateStart $dateStart,
        DateEnd $dateEnd,
        string $token
    ): ListBookingCalendarResponse {
        return new ListBookingCalendarResponse($this->repository->tourList(
            $idCategoryTour,
            $idTypeTour,
            $idTour,
            $idPackage,
            $dateStart,
            $dateEnd,
            $token
        ));
    }
}
