<?php

namespace App\Modules\BookingAssign\Application\Update;

use App\Modules\BookingAssign\Domain\IdBookingAssign;
use App\Modules\BookingAssign\Domain\BookingAssignStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\BookingAssign\Domain\BookingAssignRemark;
use App\Modules\BookingAssign\Domain\UpdateBookingAssign;

final class UpdateBookingAssignQueryHandler implements QueryHandler
{
    public function __construct(private BookingAssignUpdater $updater)
    {
    }

    public function __invoke(UpdateBookingAssignQuery $query): UpdateBookingAssignQueryResponse
    {
        $model = new UpdateBookingAssign(
            new IdBookingAssign($query->id()),
            new BookingAssignRemark($query->remark()),
            new BookingAssignStatus($query->status()),
        );
        return $this->updater->__invoke($model);
    }
}
