<?php

namespace App\Modules\BookingAssign\Application\Index;

use App\Modules\BookingAssign\Domain\IdBookingAssign;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexBookingAssignQueryHandler implements QueryHandler
{
    public function __construct(private BookingAssignIndexer $inserter)
    {
    }

    public function __invoke(IndexBookingAssignQuery $query): IndexBookingAssignQueryResponse
    {
        return $this->inserter->__invoke(new IdBookingAssign($query->getId()));
    }
}
