<?php

namespace App\Modules\BookingAssign\Application\Create;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\BookingAssign\Domain\BookingAssignRemark;
use App\Modules\BookingAssign\Domain\BookingAssignStatus;
use App\Modules\BookingAssign\Domain\InsertBookingAssign;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeBookingAssign\Domain\IdTypeBookingAssign;

final class CreateBookingAssignQueryHandler implements QueryHandler
{
    public function __construct(private BookingAssignCreator $inserter)
    {
    }

    public function __invoke(CreateBookingAssignQuery $query): CreateBookingAssignResponse
    {
        $model = new InsertBookingAssign(
            new BookingAssignRemark($query->remark()),
            new BookingAssignStatus($query->status()),
            new IdBooking($query->idBooking()),
            new IdAdmin($query->idAdmin()),
            new IdTypeBookingAssign($query->idTypeBookingAssign()),
        );
        return $this->inserter->__invoke($model);
    }
}
