<?php

namespace App\Modules\BookingAssign\Application\Create;

use App\Modules\BookingAssign\Application\Create\CreateBookingAssignResponse;
use App\Modules\BookingAssign\Domain\BookingAssign;
use App\Modules\BookingAssign\Domain\BookingAssignRepository;
use App\Modules\BookingAssign\Domain\InsertBookingAssign;

final class BookingAssignCreator
{
    public function __construct(private BookingAssignRepository $repository)
    {
    }

    public function __invoke(InsertBookingAssign $bookingAssign): CreateBookingAssignResponse
    {
        return new CreateBookingAssignResponse($this->repository->insert($bookingAssign));
    }
}
