<?php

namespace App\Modules\BookingAdditional\Application\Delete;

use App\Modules\BookingAdditional\Domain\BookingAdditional;
use App\Modules\BookingAdditional\Domain\BookingAdditionalRepository;
use App\Modules\BookingAdditional\Domain\BookingAdditionalType;
use App\Modules\BookingAdditional\Domain\Id;

final class BookingAdditionalDeleter
{
    public function __construct(private BookingAdditionalRepository $repository)
    {
    }

    public function __invoke(BookingAdditionalType $type, Id $idInternal): DeleteBookingAdditionalResponse
    {
        return new DeleteBookingAdditionalResponse($this->repository->deleteFrom($type, $idInternal));
    }
}
