<?php

namespace App\Modules\Booking\Application\SearchConfirmExcel;

use App\Modules\Booking\Domain\BookingRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class BookingConfirmExcelSearcher
{
    public function __construct(private BookingRepository $repository)
    {
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $orderBy
    ): SearchConfirmExcelBookingResponse {
        return new SearchConfirmExcelBookingResponse($this->repository->searchConfirmExcel(
            $dateStart,
            $dateEnd,
            $orderBy
        ));
    }
}
