<?php

namespace App\Modules\Booking\Application\Report\SalesByPackage;

use Illuminate\Support\Facades\DB;

final class BookingPassengersByMonthReporter
{
    public function __construct()
    {
    }

    public function __invoke($dateStart, $dateEnd)
    {
        $orderBy = '`b`.`Booking_DateConfirm`';
        // $orderBy = '`b`.`Booking_DateStart`';
        return DB::select(
            "SELECT
                `p`.`Passenger_Gender`,
                COUNT(IF($orderBy BETWEEN '2023-01-01 00:00:00' AND DATE_SUB('2023-02-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Ene 2023`,
                COUNT(IF($orderBy BETWEEN '2023-02-01 00:00:00' AND DATE_SUB('2023-03-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Feb 2023`,
                COUNT(IF($orderBy BETWEEN '2023-03-01 00:00:00' AND DATE_SUB('2023-04-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Mar 2023`,
                COUNT(IF($orderBy BETWEEN '2023-04-01 00:00:00' AND DATE_SUB('2023-05-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Abr 2023`,
                COUNT(IF($orderBy BETWEEN '2023-05-01 00:00:00' AND DATE_SUB('2023-06-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `May 2023`,
                COUNT(IF($orderBy BETWEEN '2023-06-01 00:00:00' AND DATE_SUB('2023-07-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Jun 2023`,
                COUNT(IF($orderBy BETWEEN '2023-07-01 00:00:00' AND DATE_SUB('2023-08-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Jul 2023`,
                COUNT(IF($orderBy BETWEEN '2023-08-01 00:00:00' AND DATE_SUB('2023-09-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Ago 2023`,
                COUNT(IF($orderBy BETWEEN '2023-09-01 00:00:00' AND DATE_SUB('2023-10-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Set 2023`,
                COUNT(IF($orderBy BETWEEN '2023-10-01 00:00:00' AND DATE_SUB('2023-11-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Oct 2023`,
                COUNT(IF($orderBy BETWEEN '2023-11-01 00:00:00' AND DATE_SUB('2023-12-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Nov 2023`,
                COUNT(IF($orderBy BETWEEN '2023-12-01 00:00:00' AND DATE_SUB('2024-01-01 23:59:59', INTERVAL 1 DAY), `b`.`Id_Booking`, NULL)) AS `Dic 2023`
            FROM `t_booking` `b`
            INNER JOIN `t_passenger` `p` ON `p`.`Id_Booking` = `b`.`Id_Booking`
            WHERE $orderBy BETWEEN ? AND DATE_SUB(?, INTERVAL 1 DAY)
            AND `b`.`Booking_Status` IN (2, 3)
            AND `p`.`Passenger_Status` = 2
            GROUP BY `b`.`Id_GuideLanguage`",
            [$dateStart, $dateEnd]
        );
    }
}
