<?php

namespace App\Modules\Booking\Application;

class BookingPackSearch {

    public function __invoke ($oData) {
        return array_map([$this, 'richData'](), $oData);
    }

    private function richData()
    {
        return function ($booking) {
            if ($booking->Admin_ImgProfile) {
                $booking->Admin_ImgProfile = config('var.PATH_PUBLIC') . $booking->Admin_ImgProfile;
            }
            if ($booking->Admin_ImgProfile_Thumb) {
                $booking->Admin_ImgProfile_Thumb = config('var.PATH_PUBLIC') . $booking->Admin_ImgProfile_Thumb;
            }
            $booking->BookingTourCodes = $booking->BookingTourCodes ?? '[]';
            $booking->BookingPackageCodes = $booking->BookingPackageCodes ?? '[]';
            $booking->BookingAssign = json_decode($booking->BookingAssign);
            foreach ($booking->BookingAssign as $bookingAssign) {
                if ($bookingAssign->Admin_ImgProfile_Thumb) {
                    $bookingAssign->Admin_ImgProfile_Thumb = config('var.PATH_PUBLIC') . $bookingAssign->Admin_ImgProfile_Thumb;
                }
            }
            $booking->User_Path = config('var.PATH_PUBLIC') . config("var.USER_COUNTRY_THUMB");
            return $booking;
        };
    }

}