<?php

namespace App\Modules\AdminSession\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Lead\Domain\IdLead;

class AdminSession
{

    /** constructor */
    public function __construct(
        private AdminSessionStatus $status,
        private IdAdmin $idAdmin,
        private IdLanguage $idGuideLanguage,
        private IdLanguage $idLanguage,
        private IdLead $idLead,
        private ?IdAdminSession $id = null
    ) {
    }
    public function getStatus(): AdminSessionStatus
    {
        return $this->status;
    }
    public function getIdAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }
    public function getIdGuideLanguage(): IdLanguage
    {
        return $this->idGuideLanguage;
    }
    public function getIdLanguage(): IdLanguage
    {
        return $this->idLanguage;
    }
    public function getIdLead(): IdLead
    {
        return $this->idLead;
    }
    public function getId(): IdAdminSession
    {
        return $this->id;
    }
}
